# WaSender Pro – Landing Page Premium

## 📋 Descripción
Landing page premium de alta conversión para **WaSender Pro**, suite 20-en-1 de WhatsApp Marketing. Diseño Dark Luxury + Glassmorphism + Glow verde WhatsApp.

---

## 🎨 Paleta de Colores

| Token              | Valor     | Uso                            |
|--------------------|-----------|--------------------------------|
| `--bg-primary`     | `#000000` | Fondo principal                |
| `--bg-secondary`   | `#09090B` | Fondos de secciones alternas   |
| `--bg-tertiary`    | `#18181B` | Tarjetas y elementos           |
| `--primary-500`    | `#22C55E` | Acento principal (verde WA)    |
| `--primary-400`    | `#4ade80` | Textos acento, iconos          |
| `--text-primary`   | `#FFFFFF` | Títulos y textos principales   |
| `--text-secondary` | `#E4E4E7` | Párrafos secundarios           |
| `--text-tertiary`  | `#A1A1AA` | Textos de apoyo                |
| `--text-quaternary`| `#71717A` | Disclaimers, pies de página    |

### Escala completa --primary

```
--primary-50:  #f0fdf4
--primary-100: #dcfce7
--primary-200: #bbf7d0
--primary-300: #86efac
--primary-400: #4ade80
--primary-500: #22C55E  ← BASE
--primary-600: #16a34a
--primary-700: #15803d
--primary-800: #166534
--primary-900: #14532d
```

---

## 🅰 Tipografías

| Uso      | Familia            | Pesos        |
|----------|--------------------|--------------|
| Títulos  | Plus Jakarta Sans  | 700, 800     |
| Cuerpo   | Inter              | 300, 400, 500, 600 |

Ambas vienen de Google Fonts (importadas en `styles.css`).

---

## 📁 Estructura de archivos

```
Wasender 2/
├── index.html        ← Página principal completa
├── styles.css        ← Todo el CSS (design system + componentes)
├── script.js         ← Toda la lógica JS
├── README.md         ← Este archivo
└── images/
    ├── logo.png           ← Logo 512×512 PNG transparente
    ├── hero_visual.png    ← Visual hero 1200×1200
    ├── feature_1.png      ← Envíos masivos
    ├── feature_2.png      ← Validador de números
    ├── feature_3.png      ← Extractor de grupos
    ├── feature_4.png      ← Auto-responder
    ├── feature_5.png      ← Extracción y exportación
    └── feature_6.png      ← Programación + extra tools
```

---

## 🧩 Secciones del sitio

1. **Navbar sticky** – Logo + links + CTA, con blur al hacer scroll
2. **Hero (100vh)** – Badge + H1 + subtítulo + 2 CTAs + badges flotantes + partículas
3. **Métricas / Social Proof** – 4 contadores animados + logos de sectores
4. **Funciones (Flip Cards 3D)** – 6 tarjetas con imagen frontal y descripción al girar
5. **Cómo funciona** – 4 pasos con conector horizontal
6. **Precio** – Tarjeta premium con promo 50% off + card de garantía
7. **Testimonios** – 6 cards con estrellas y avatars de colores
8. **FAQ** – 8 preguntas con accordion animado
9. **CTA Final** – Gradiente radial verde + botón con animación pulse
10. **Footer** – Grid 4 columnas + aviso legal

---

## ✏️ Cómo editar textos y precio

### Cambiar precio
En `index.html`, busca `$15` y `$30` en la sección `#precio`.

```html
<span class="strike">$30</span>   ← Precio tachado (normal)
<span class="price-amount">$15</span>  ← Precio promo
```

### Cambiar número de WhatsApp
En `script.js`, modifica la constante al inicio:
```js
const WHATSAPP_NUMBER = '593960705007';
```

En `index.html`, reemplaza todas las ocurrencias de `wa.me/593960705007`.

### Cambiar textos de funciones / pasos / testimonios
Directamente en `index.html`, cada sección tiene `id` descriptivos para ubicarlas fácilmente:
- `#funciones` → Flip cards
- `#como-funciona` → Pasos
- `#precio` → Pricing card
- `#testimonios` → Testimonios
- `#faq` → FAQ

---

## ⚙️ Funcionalidades JS

| Feature                | Descripción                                                       |
|------------------------|-------------------------------------------------------------------|
| Partículas (canvas)    | 50 partículas flotantes verdes + líneas de conexión               |
| Navbar sticky          | Cambia a fondo blur al hacer scroll > 30px                        |
| Menú hamburguesa       | Menú móvil animado con bloqueo de scroll                          |
| Smooth scroll          | Scroll suave a secciones con `href="#seccion"`                    |
| Reveal por scroll      | IntersectionObserver con fade-in-up + stagger delays              |
| Contadores animados    | Animación numérica en métricas al entrar en viewport              |
| Flip Cards 3D          | Hover en desktop, tap en móvil, teclado accesible                |
| FAQ Accordion          | Solo una abierta a la vez, animación de max-height                |
| Parallax sutil         | El glow del hero sigue el cursor del mouse                        |
| Active nav link        | Resalta el link del navbar según sección visible                  |

---

## 🚀 Despliegue

El proyecto es **100% estático** (HTML + CSS + JS puro). Para publicar:

1. **GitHub Pages**: sube los archivos a un repositorio y activa Pages
2. **Netlify / Vercel**: arrastra la carpeta al dashboard
3. **Hosting tradicional**: sube via FTP la carpeta completa

No requiere Node.js, build steps ni dependencias.

---

## ⚠️ Aviso de cumplimiento

> WaSender Pro debe utilizarse **siempre con el consentimiento** de los destinatarios y en pleno cumplimiento de las **Políticas de uso de WhatsApp** (Meta) y las **leyes locales anti-spam** vigentes en cada país.
>
> Este software es una herramienta independiente y **no está afiliado, patrocinado ni respaldado** por WhatsApp Inc. o Meta Platforms, Inc.

---

*Diseñado y desarrollado como landing page de alta conversión para WaSender Pro.*
